package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.config.URLCreator;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.enums.InitType.InitTypeVisitor;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionCommand;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.web.WebTransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import lombok.AllArgsConstructor;
import lombok.Builder;

@AllArgsConstructor
@Builder
public class TransactionInitiatorFactory implements InitTypeVisitor<TransactionInitiator> {

    private MerchantConfig merchantConfig;
    private InitConfig initConfig;
    private TransactionCommand transactionCommand;
    private ChecksumGenerator checksumGenerator;
    private URLCreator urlCreator;
    private PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;

    @Override
    public TransactionInitiator visitWeb() {
        return WebTransactionInitiator
                .builder()
                .phonePeHttpRequestCreator(this.phonePeHttpRequestCreator)
                .checksumGenerator(this.checksumGenerator)
                .transactionCommand(this.transactionCommand)
                .merchantConfig(this.merchantConfig)
                .initConfig(this.initConfig)
                .urlCreator(this.urlCreator)
                .build();
    }

    @Override
    public TransactionInitiator visitIntent() {
        return null;
    }
}
