package com.phonepe.sdk.javasdk.config.models.enums;

public enum InitType {

    WEB() {
        @Override
        public <T> T accept(InitTypeVisitor<T> visitor) {
            return visitor.visitWeb();
        }
    }, INTENT() {
        @Override
        public <T> T accept(InitTypeVisitor<T> visitor) {
            return visitor.visitIntent();
        }
    };

    public abstract <T> T accept(InitTypeVisitor<T> visitor);

    public interface InitTypeVisitor<T> {
        T visitWeb();

        T visitIntent();
    }
}
