package com.phonepe.sdk.javasdk.config.models;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import okhttp3.ConnectionSpec;
import okhttp3.TlsVersion;
import okhttp3.logging.HttpLoggingInterceptor.Level;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

@Data
@NoArgsConstructor
public class HttpClientConfig {

    @Min(10)
    @Max(1024)
    private int connections = 10;

    @Max(86400)
    private int idleTimeOutSeconds = 30;

    @Max(86400000)
    private int connectTimeoutMs = 10000;

    @Max(86400000)
    private int opTimeoutMs = 10000;

    private TlsVersion tlsVersion = TlsVersion.TLS_1_2;

    private ConnectionSpec connectionSpec = ConnectionSpec.MODERN_TLS;

    private Level loggingLevel = Level.NONE;

    @Builder
    public HttpClientConfig(@Min(10) @Max(1024) final int connections,
                            @Max(86400) final int idleTimeOutSeconds,
                            @Max(86400000) final int connectTimeoutMs,
                            @Max(86400000) final int opTimeoutMs,
                            final TlsVersion tlsVersion,
                            final ConnectionSpec connectionSpec,
                            final Level loggingLevel){
        this.connections = connections == 0
                           ? 10
                           : connections;
        this.idleTimeOutSeconds = idleTimeOutSeconds == 0
                                  ? 30
                                  : idleTimeOutSeconds;
        this.connectTimeoutMs = connectTimeoutMs == 0
                                ? 10000
                                : connectTimeoutMs;
        this.opTimeoutMs = opTimeoutMs == 0
                           ? 10000
                           : opTimeoutMs;

        this.connectionSpec = connectionSpec == null ? ConnectionSpec.MODERN_TLS : connectionSpec;
        this.tlsVersion = tlsVersion == null ? TlsVersion.TLS_1_2 : tlsVersion;
        this.loggingLevel = loggingLevel == null ? Level.NONE : loggingLevel;

    }
}

