package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.enums.Environment;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.StringUtils;

@Data
@NoArgsConstructor
public class Endpoint {

    private Environment environment = Environment.UAT;
    private String overrideHost;

    @Builder
    public Endpoint(final Environment environment,
                    final String overrideHost) {
        this.environment = environment == null
                           ? Environment.UAT
                           : environment;
        if (StringUtils.isNotEmpty(overrideHost)) {
            this.overrideHost = overrideHost;
        }
    }
}
