package com.phonepe.sdk.javasdk.config;

import com.phonepe.sdk.javasdk.config.models.DefaultConfig;
import com.phonepe.sdk.javasdk.config.models.enums.Environment;
import lombok.AllArgsConstructor;
import lombok.Builder;

@AllArgsConstructor
@Builder
public class DefaultEndpointCreator implements Environment.EnvironmentVisitor<String> {

    private DefaultConfig defaultConfig;

    @Override
    public String visitUat() {
        return defaultConfig.getUatEndpoint();
    }

    @Override
    public String visitProduction() {
        return defaultConfig.getProdEndpoint();
    }
}
