package com.phonepe.sdk.javasdk.transaction.models;


import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.enums.CallbackMode;
import com.phonepe.sdk.javasdk.transaction.init.models.enums.RedirectMode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InitParams {

    @NotNull
    private String transactionId;
    @Min(1L)
    private long amount;
    private String orderId;
    private String userId;
    private String emailId;
    private String subMerchant;
    private String subMerchantId;
    private String mobileNumber;
    private String shortName;
    private String message;
    private Set<String> offerTags;
    private String redirectURL;
    private RedirectMode redirectMode;
    private String callbackURL;
    private CallbackMode callbackMode;
    private List<AllowedAccountConstraint> allowedAccountConstraints;

}
