package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.enums.APIVersion;
import com.phonepe.sdk.javasdk.config.models.enums.InitType;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@NoArgsConstructor
public class InitConfig {

    protected APIVersion apiVersion = APIVersion.V4;
    protected String overrideHost;
    private InitType initType = InitType.WEB;

    @Builder
    @SuppressWarnings("unused")
    public InitConfig(final APIVersion apiVersion,
                      final InitType initType,
                      final String overrideHost) {

        this.overrideHost = overrideHost;
        this.apiVersion = apiVersion == null ? APIVersion.V4 : apiVersion;
        this.initType = initType == null ? InitType.WEB : initType;
    }
}
