/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.phonepe.sdk.javasdk.config.URLCreator;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionCommand;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.AccountConstraintsDecorator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.BaseTransactionInit;
import com.phonepe.sdk.javasdk.transaction.init.decorator.OfferInitDecorator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.models.InitParams;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebTransactionInitiator
extends TransactionInitiator {
    private static final Logger log = LoggerFactory.getLogger(WebTransactionInitiator.class);

    public WebTransactionInitiator(TransactionCommand transactionCommand, InitConfig initConfig, MerchantConfig merchantConfig, ChecksumGenerator checksumGenerator, URLCreator urlCreator, PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        super(transactionCommand, initConfig, merchantConfig, checksumGenerator, urlCreator, phonePeHttpRequestCreator);
    }

    @Override
    protected PhonePeHttpRequest<?> buildInitRequest(String merchantId, InitParams initParams) throws JsonProcessingException {
        TransactionInitComponent transactionInitComponent = BaseTransactionInit.builder().merchantId(merchantId).transactionId(initParams.getTransactionId()).amount(initParams.getAmount()).emailId(initParams.getEmailId()).merchantOrderId(StringUtils.isNotEmpty((String)initParams.getOrderId()) ? initParams.getOrderId() : initParams.getTransactionId()).merchantUserId(initParams.getUserId()).mobileNumber(initParams.getMobileNumber()).shortName(initParams.getShortName()).subMerchant(initParams.getSubMerchant()).subMerchantId(initParams.getSubMerchantId()).message(initParams.getMessage()).build();
        if (CollectionUtils.isNotEmpty(initParams.getOfferTags())) {
            transactionInitComponent = OfferInitDecorator.builder().transactionInitComponent(transactionInitComponent).offerTagIds(initParams.getOfferTags()).build();
        }
        if (CollectionUtils.isNotEmpty(initParams.getAllowedAccountConstraints())) {
            transactionInitComponent = AccountConstraintsDecorator.builder().transactionInitComponent(transactionInitComponent).allowedAccountConstraints(initParams.getAllowedAccountConstraints()).build();
        }
        InitRequest initRequest = transactionInitComponent.getInitRequest();
        return this.phonePeHttpRequestCreator.createPhonePeHttpRequest(initRequest);
    }

    public static WebTransactionInitiatorBuilder builder() {
        return new WebTransactionInitiatorBuilder();
    }

    public static class WebTransactionInitiatorBuilder {
        private TransactionCommand transactionCommand;
        private InitConfig initConfig;
        private MerchantConfig merchantConfig;
        private ChecksumGenerator checksumGenerator;
        private URLCreator urlCreator;
        private PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;

        WebTransactionInitiatorBuilder() {
        }

        public WebTransactionInitiatorBuilder transactionCommand(TransactionCommand transactionCommand) {
            this.transactionCommand = transactionCommand;
            return this;
        }

        public WebTransactionInitiatorBuilder initConfig(InitConfig initConfig) {
            this.initConfig = initConfig;
            return this;
        }

        public WebTransactionInitiatorBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public WebTransactionInitiatorBuilder checksumGenerator(ChecksumGenerator checksumGenerator) {
            this.checksumGenerator = checksumGenerator;
            return this;
        }

        public WebTransactionInitiatorBuilder urlCreator(URLCreator urlCreator) {
            this.urlCreator = urlCreator;
            return this;
        }

        public WebTransactionInitiatorBuilder phonePeHttpRequestCreator(PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
            this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
            return this;
        }

        public WebTransactionInitiator build() {
            return new WebTransactionInitiator(this.transactionCommand, this.initConfig, this.merchantConfig, this.checksumGenerator, this.urlCreator, this.phonePeHttpRequestCreator);
        }

        public String toString() {
            return "WebTransactionInitiator.WebTransactionInitiatorBuilder(transactionCommand=" + this.transactionCommand + ", initConfig=" + this.initConfig + ", merchantConfig=" + this.merchantConfig + ", checksumGenerator=" + this.checksumGenerator + ", urlCreator=" + this.urlCreator + ", phonePeHttpRequestCreator=" + this.phonePeHttpRequestCreator + ")";
        }
    }
}

