/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.phonepe.sdk.javasdk.config.models.DefaultConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.Consumer;
import com.phonepe.sdk.javasdk.http.PhonePeHttpCommand;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCommand {
    private static final Logger log = LoggerFactory.getLogger(TransactionCommand.class);
    private final OkHttpClient client;
    private final DefaultConfig defaultConfig;
    private final List<HttpHeaderPair> metaHeaders;
    private static final String INITIATE_TRANSACTION = "initTransaction";
    private static final String TRANSACTION_STATUS = "transactionStatus";

    public TransactionCommand(OkHttpClient okHttpClient, DefaultConfig defaultConfig) throws IOException {
        this.client = okHttpClient;
        this.defaultConfig = defaultConfig;
        this.metaHeaders = this.getMetaHeaders();
    }

    public <T> InitResponse initTransaction(PhonePeHttpRequest<T> initRequest, List<HttpHeaderPair> httpHeaders, HttpUrl httpUrl) throws PhonePeClientException {
        try {
            Consumer<ExtractedResponse, T> initResponseConsumer = TransactionCommand.handleNonSuccessServiceCall(log, INITIATE_TRANSACTION);
            httpHeaders.addAll(this.metaHeaders);
            PhonePeHttpResponse<InitResponse> phonePeHttpResponse = PhonePeHttpCommand.builder().client(this.client).responseTypeReference(new TypeReference<PhonePeHttpResponse<InitResponse>>(){}).nonSuccessResponseConsumer(initResponseConsumer).build().doPost(httpUrl, httpHeaders, initRequest);
            return phonePeHttpResponse.getData();
        }
        catch (PhonePeClientException e) {
            log.error("Error while making call to PhonePe init transaction API: {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe init transaction API: {}", (Object)e.getMessage());
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", e.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_CLIENT_ERROR, "Error executing http client for initiating transaction: " + e.getMessage(), objectMap, e);
        }
    }

    public PhonePeHttpResponse<TransactionStatusResponse> getTransactionStatus(List<HttpHeaderPair> httpHeaders, HttpUrl httpUrl) throws PhonePeClientException {
        try {
            Consumer transactionResponseConsumer = TransactionCommand.handleNonSuccessServiceCall(log, TRANSACTION_STATUS);
            httpHeaders.addAll(this.metaHeaders);
            return PhonePeHttpCommand.builder().client(this.client).responseTypeReference(new TypeReference<PhonePeHttpResponse<TransactionStatusResponse>>(){}).nonSuccessResponseConsumer(transactionResponseConsumer).build().doGet(httpUrl, httpHeaders);
        }
        catch (PhonePeClientException e) {
            log.error("Error while making call to PhonePe transaction status API ");
            throw e;
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe transaction status API ", (Throwable)e);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", e.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_CLIENT_ERROR, "Error executing http client for transaction status: " + e.getMessage(), objectMap, e);
        }
    }

    public static <T> Consumer<ExtractedResponse, T> handleNonSuccessServiceCall(final Logger log, final String serviceName) {
        return new Consumer<ExtractedResponse, T>(){

            @Override
            public T consume(ExtractedResponse extractedResponse) throws PhonePeClientException {
                int code = extractedResponse.getCode();
                byte[] body = extractedResponse.getBody();
                String bodyString = new String(body);
                log.error("Error while calling {} service code: {}, response:{}", new Object[]{serviceName, code, bodyString});
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_SERVER_ERROR, serviceName + " http call returned code " + code);
            }
        };
    }

    private List<HttpHeaderPair> getMetaHeaders() throws IOException {
        ArrayList<HttpHeaderPair> metaHeadersList = new ArrayList<HttpHeaderPair>();
        metaHeadersList.add(HttpUtils.getJavaSdkVersionHeader(this.defaultConfig));
        return metaHeadersList;
    }
}

