/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.Consumer;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.utils.MapperUtils;
import java.nio.charset.Charset;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeHttpCommand<T> {
    private static final Logger log = LoggerFactory.getLogger(PhonePeHttpCommand.class);
    private OkHttpClient client;
    private Class<T> responseType;
    private TypeReference<T> responseTypeReference;
    private Consumer<Exception, T> exceptionConsumer;
    private Consumer<ExtractedResponse, T> nonSuccessResponseConsumer;

    PhonePeHttpCommand(OkHttpClient client, Class<T> responseType, Consumer<Exception, T> exceptionConsumer, Consumer<ExtractedResponse, T> nonSuccessResponseConsumer, TypeReference<T> responseTypeReference) {
        this.client = client;
        this.responseType = responseType;
        this.exceptionConsumer = exceptionConsumer;
        this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
        this.responseTypeReference = responseTypeReference;
    }

    <J> RequestBody getRequestBody(PhonePeHttpRequest<J> httpRequest) throws JsonProcessingException {
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])MapperUtils.getMapper().writeValueAsBytes(httpRequest.getData()));
    }

    public void buildHeaders(Request.Builder requestBuilder, List<HttpHeaderPair> headers) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{headers})) {
            for (HttpHeaderPair httpHeader : headers) {
                requestBuilder.header(httpHeader.getName(), httpHeader.getValue());
            }
        }
    }

    public T doGet(HttpUrl httpUrl, List<HttpHeaderPair> headers) throws PhonePeClientException {
        this.preconditions(false, httpUrl, null);
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).get();
        this.buildHeaders(requestBuilder, headers);
        return this.execute(requestBuilder.build());
    }

    public <J> T doPost(HttpUrl httpUrl, List<HttpHeaderPair> headers, PhonePeHttpRequest<J> httpRequest) throws JsonProcessingException, PhonePeClientException {
        this.preconditions(true, httpUrl, httpRequest);
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).post(this.getRequestBody(httpRequest));
        this.buildHeaders(requestBuilder, headers);
        return this.execute(requestBuilder.build());
    }

    public T execute(Request request) throws PhonePeClientException {
        try {
            log.info("Service request: {}", (Object)request);
            Response response = this.client.newCall(request).execute();
            byte[] responseBody = HttpUtils.body(response);
            if (!response.isSuccessful()) {
                if (this.nonSuccessResponseConsumer != null) {
                    return this.nonSuccessResponseConsumer.consume(this.extract(response, responseBody));
                }
                log.error(String.format("Service call failed statusCode:%d request:%s response:%s", response.code(), request, new String(responseBody)));
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_CLIENT_ERROR, "Service call failure: " + response.code());
            }
            if (ObjectUtils.anyNotNull((Object[])new Object[]{responseBody})) {
                if (this.responseTypeReference != null) {
                    return (T)MapperUtils.getMapper().readValue(responseBody, this.responseTypeReference);
                }
                if (byte[].class.equals(this.responseType)) {
                    return (T)responseBody;
                }
                if (String.class.equals(this.responseType)) {
                    return (T)new String(responseBody, Charset.defaultCharset());
                }
                return (T)MapperUtils.getMapper().readValue(responseBody, this.responseType);
            }
            return null;
        }
        catch (Exception e) {
            if (this.exceptionConsumer != null) {
                return this.exceptionConsumer.consume(e);
            }
            log.error(String.format("Error executing request:%s error:%s", request, e.getMessage()), (Throwable)e);
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, e.getMessage(), e);
        }
    }

    public <J> void preconditions(boolean isPost, HttpUrl httpUrl, PhonePeHttpRequest<J> httpRequest) throws PhonePeClientException {
        Preconditions.checkNotNull((Object)this.client, (Object)"client cannot be null");
        Preconditions.checkNotNull((Object)httpUrl, (Object)"httpUrl cannot be null");
        HttpUtils.checkNotNull(this.responseType, this.responseTypeReference, "both responseType and responseTypeReference cannot be null");
        if (isPost) {
            Preconditions.checkNotNull(httpRequest, (Object)"postData cannot be null");
        }
    }

    private ExtractedResponse extract(Response response, byte[] responseBody) {
        return ExtractedResponse.builder().body(responseBody).code(response.code()).headers(response.headers()).message(response.message()).protocol(response.protocol()).handshake(response.handshake()).receivedResponseAtMillis(response.receivedResponseAtMillis()).sentRequestAtMillis(response.sentRequestAtMillis()).build();
    }

    public static <T> PhonePeHttpCommandBuilder<T> builder() {
        return new PhonePeHttpCommandBuilder();
    }

    public static class PhonePeHttpCommandBuilder<T> {
        private OkHttpClient client;
        private Class<T> responseType;
        private Consumer<Exception, T> exceptionConsumer;
        private Consumer<ExtractedResponse, T> nonSuccessResponseConsumer;
        private TypeReference<T> responseTypeReference;

        PhonePeHttpCommandBuilder() {
        }

        public PhonePeHttpCommandBuilder<T> client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public PhonePeHttpCommandBuilder<T> responseType(Class<T> responseType) {
            this.responseType = responseType;
            return this;
        }

        public PhonePeHttpCommandBuilder<T> exceptionConsumer(Consumer<Exception, T> exceptionConsumer) {
            this.exceptionConsumer = exceptionConsumer;
            return this;
        }

        public PhonePeHttpCommandBuilder<T> nonSuccessResponseConsumer(Consumer<ExtractedResponse, T> nonSuccessResponseConsumer) {
            this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
            return this;
        }

        public PhonePeHttpCommandBuilder<T> responseTypeReference(TypeReference<T> responseTypeReference) {
            this.responseTypeReference = responseTypeReference;
            return this;
        }

        public PhonePeHttpCommand<T> build() {
            return new PhonePeHttpCommand<T>(this.client, this.responseType, this.exceptionConsumer, this.nonSuccessResponseConsumer, this.responseTypeReference);
        }

        public String toString() {
            return "PhonePeHttpCommand.PhonePeHttpCommandBuilder(client=" + this.client + ", responseType=" + this.responseType + ", exceptionConsumer=" + this.exceptionConsumer + ", nonSuccessResponseConsumer=" + this.nonSuccessResponseConsumer + ", responseTypeReference=" + this.responseTypeReference + ")";
        }
    }
}

