/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config;

import com.phonepe.sdk.javasdk.config.DefaultEndpointCreator;
import com.phonepe.sdk.javasdk.config.DefaultUrlCreator;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.enums.ConfigType;
import java.net.URI;
import okhttp3.HttpUrl;
import org.apache.commons.lang.StringUtils;

public class URLCreator {
    private DefaultEndpointCreator defaultEndpointCreator;
    private DefaultUrlCreator defaultUrlCreator;
    private Endpoint endpoint;

    public HttpUrl getHttpUrl(ConfigType configType, String overrideHost, String ... pathFormatArgs) {
        String hostEndpoint = StringUtils.isNotEmpty((String)overrideHost) ? overrideHost : this.getDefaultHostEndpoint();
        String url = this.getCompleteUrl(hostEndpoint, configType.accept(this.defaultUrlCreator), pathFormatArgs);
        return HttpUrl.get((URI)URI.create(url));
    }

    private String getDefaultHostEndpoint() {
        return StringUtils.isNotEmpty((String)this.endpoint.getOverrideHost()) ? this.endpoint.getOverrideHost() : this.endpoint.getEnvironment().accept(this.defaultEndpointCreator);
    }

    private String getCompleteUrl(String hostEndpoint, String pathFormatString, String ... pathFormatArgs) {
        String path = String.format(pathFormatString, pathFormatArgs);
        return String.format("%s%s", hostEndpoint, path);
    }

    public static URLCreatorBuilder builder() {
        return new URLCreatorBuilder();
    }

    public URLCreator(DefaultEndpointCreator defaultEndpointCreator, DefaultUrlCreator defaultUrlCreator, Endpoint endpoint) {
        this.defaultEndpointCreator = defaultEndpointCreator;
        this.defaultUrlCreator = defaultUrlCreator;
        this.endpoint = endpoint;
    }

    public static class URLCreatorBuilder {
        private DefaultEndpointCreator defaultEndpointCreator;
        private DefaultUrlCreator defaultUrlCreator;
        private Endpoint endpoint;

        URLCreatorBuilder() {
        }

        public URLCreatorBuilder defaultEndpointCreator(DefaultEndpointCreator defaultEndpointCreator) {
            this.defaultEndpointCreator = defaultEndpointCreator;
            return this;
        }

        public URLCreatorBuilder defaultUrlCreator(DefaultUrlCreator defaultUrlCreator) {
            this.defaultUrlCreator = defaultUrlCreator;
            return this;
        }

        public URLCreatorBuilder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public URLCreator build() {
            return new URLCreator(this.defaultEndpointCreator, this.defaultUrlCreator, this.endpoint);
        }

        public String toString() {
            return "URLCreator.URLCreatorBuilder(defaultEndpointCreator=" + this.defaultEndpointCreator + ", defaultUrlCreator=" + this.defaultUrlCreator + ", endpoint=" + this.endpoint + ")";
        }
    }
}

