package com.phonepe.sdk.javasdk.transaction.request;

import com.phonepe.sdk.javasdk.config.models.enums.APIVersion.APIVersionVisitor;

public class PhonePeHttpRequestCreatorFactory<T> implements APIVersionVisitor<PhonePeHttpRequestCreator<T>> {

    @Override
    public PhonePeHttpRequestCreator<T> visitV1() {
        return DefaultRequestCreator.<T>builder().build();
    }

    @Override
    public PhonePeHttpRequestCreator<T> visitV2() {
        return DefaultRequestCreator.<T>builder().build();
    }

    @Override
    public PhonePeHttpRequestCreator<T> visitV3() {
        return Base64RequestCreator.<T>builder().build();

    }

    @Override
    public PhonePeHttpRequestCreator<T> visitV4() {
        return Base64RequestCreator.<T>builder().build();
    }
}