package com.phonepe.sdk.javasdk.transaction.models.enums;

import com.phonepe.sdk.javasdk.exception.PhonePeClientException;

public enum TransactionStatusCode {

    PAYMENT_PENDING {
        @Override
        public <T> T accept(TransactionStatusCode.TransactionStatusCodeVisitor<T> visitor) {
            return visitor.visitPaymentPending();
        }
    },
    INTERNAL_SERVER_ERROR{
        @Override
        public <T> T accept(TransactionStatusCode.TransactionStatusCodeVisitor<T> visitor) {
            return visitor.visitInternalServerError();
        }
    },
    PAYMENT_SUCCESS{
        @Override
        public <T> T accept(TransactionStatusCode.TransactionStatusCodeVisitor<T> visitor) {
            return visitor.visitPaymentSuccess();
        }
    },
    PAYMENT_ERROR{
        @Override
        public <T> T accept(TransactionStatusCode.TransactionStatusCodeVisitor<T> visitor) {
            return visitor.visitPaymentError();
        }
    },
    PAYMENT_DECLINED{
        @Override
        public <T> T accept(TransactionStatusCode.TransactionStatusCodeVisitor<T> visitor) {
            return visitor.visitPaymentDeclined();
        }
    },
    PAYMENT_CANCELLED{
        @Override
        public <T> T accept(TransactionStatusCode.TransactionStatusCodeVisitor<T> visitor) {
            return visitor.visitPaymentCancelled();
        }
    },
    TRANSACTION_NOT_FOUND{
        @Override
        public <T> T accept(TransactionStatusCode.TransactionStatusCodeVisitor<T> visitor) {
            return visitor.visitTransactionNotFound();
        }
    },
    UNKNOWN {
        @Override
        public <T> T accept(TransactionStatusCode.TransactionStatusCodeVisitor<T> visitor) /*throws PhonePeClientException */{
            return visitor.visitUnknown();
        }
    };

    public abstract <T> T accept(TransactionStatusCode.TransactionStatusCodeVisitor<T> visitor) throws PhonePeClientException;

    public interface TransactionStatusCodeVisitor<T> {
        T visitPaymentPending();

        T visitInternalServerError();

        T visitPaymentSuccess();

        T visitPaymentError();

        T visitPaymentDeclined();

        T visitPaymentCancelled();

        T visitTransactionNotFound();

        T visitUnknown() /*throws PhonePeClientException */;
    }
}
