package com.phonepe.sdk.javasdk.transaction.init.decorator;


import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantContext;
import com.phonepe.sdk.javasdk.transaction.init.models.OfferContext;
import com.phonepe.sdk.javasdk.transaction.init.models.OfferTag;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashSet;
import java.util.Set;

/**
 * Decorator that will populate the {@link com.phonepe.sdk.javasdk.transaction.init.models.InitRequest}
 * with deep offer details.
 */

@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class OfferInitDecorator extends InitRequestDecorator {

    private Set<String> offerTagIds;

    @Builder
    public OfferInitDecorator(final TransactionInitComponent transactionInitComponent,
                              final Set<String> offerTagIds) {
        super(transactionInitComponent);
        this.offerTagIds = offerTagIds;
    }

    @Override
    public InitRequest getInitRequest() {
        InitRequest initRequest = this.transactionInitComponent.getInitRequest();
        Set<OfferTag> offerTagSet = getOfferTags(initRequest.getAmount());
        OfferContext offerContext = OfferContext
                .builder()
                .tags(offerTagSet)
                .build();
        MerchantContext merchantContext = initRequest.getMerchantContext();
        if (merchantContext != null) {
            merchantContext.setOfferContext(offerContext);
        } else {
            merchantContext = MerchantContext
                    .builder()
                    .offerContext(offerContext)
                    .build();

        }
        initRequest.setMerchantContext(merchantContext);
        return initRequest;
    }

    private Set<OfferTag> getOfferTags(final Long amount) {
        Set<OfferTag> offerTags = new HashSet<>();
        for (String tagId : this.offerTagIds) {
            offerTags.add(OfferTag
                                  .builder()
                                  .id(tagId)
                                  .amount(amount)
                                  .build());
        }
        return offerTags;
    }

}
