package com.phonepe.sdk.javasdk.config;

import com.phonepe.sdk.javasdk.config.models.DefaultConfig;
import com.phonepe.sdk.javasdk.config.models.enums.ConfigType;
import lombok.AllArgsConstructor;
import lombok.Builder;

@AllArgsConstructor
@Builder
public class DefaultUrlCreator implements ConfigType.ConfigTypeVisitor<String> {

    private DefaultConfig defaultConfig;

    @Override
    public String visitInit() {
        return defaultConfig.getDebitUrlString();
    }

    @Override
    public String visitStatus() {
        return defaultConfig.getTransactionStatusUrlString();
    }
}
