/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.status;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.google.common.base.Predicate;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.enums.PaymentState;
import com.phonepe.sdk.javasdk.utils.KeyUtils;
import com.phonepe.sdk.javasdk.utils.RetryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionStatusChecker {
    private static final Logger log = LoggerFactory.getLogger(TransactionStatusChecker.class);
    private TransactionClient transactionClient;
    private StatusConfig statusConfig;
    private MerchantConfig merchantConfig;
    private ChecksumGenerator checksumGenerator;
    private String apiURLString;
    private static String PAYMENT_PENDING = "PAYMENT_PENDING";
    private static String INTERNAL_SERVER_ERROR = "INTERNAL_SERVER_ERROR";
    private static String PAYMENT_SUCCESS = "PAYMENT_SUCCESS";
    private static String PAYMENT_ERROR = "PAYMENT_ERROR";
    private static String PAYMENT_DECLINED = "PAYMENT_DECLINED";
    private static String PAYMENT_CANCELLED = "PAYMENT_CANCELLED";
    private static String TRANSACTION_NOT_FOUND = "TRANSACTION_NOT_FOUND";

    public TransactionStatusChecker(TransactionClient transactionClient, MerchantConfig merchantConfig, StatusConfig statusConfig, ChecksumGenerator checksumGenerator) {
        this.transactionClient = transactionClient;
        this.merchantConfig = merchantConfig;
        this.statusConfig = statusConfig;
        this.checksumGenerator = checksumGenerator;
        this.apiURLString = String.format("/%s/", this.statusConfig.getApiVersion().getValue()).concat("transaction/%s/%s/status");
    }

    public StatusResponse checkTransactionStatus(String transactionId, int keyIndex) throws PhonePeClientException {
        try {
            String apiURL = this.getAPIURL(transactionId);
            String apiKey = KeyUtils.getAPIKeyFromIndex(this.merchantConfig.getApiKeys(), keyIndex);
            List<String> params = this.getParamsList(transactionId);
            String checksumHeaderValue = this.checksumGenerator.getChecksumValue(null, apiURL, params, apiKey, keyIndex);
            List<HttpHeaderPair> httpHeaders = HttpUtils.getHttpHeaders(checksumHeaderValue);
            Callable<PhonePeHttpResponse<TransactionStatusResponse>> transactionStatusCallable = this.getCallable(apiURL, httpHeaders);
            Predicate<PhonePeHttpResponse<TransactionStatusResponse>> phonePeHttpResponsePredicate = this.getRetryPredicate();
            Retryer<PhonePeHttpResponse<TransactionStatusResponse>> retryer = RetryUtils.getRetryer(this.statusConfig.getRetryConfig(), phonePeHttpResponsePredicate);
            PhonePeHttpResponse phonePeHttpResponse = (PhonePeHttpResponse)retryer.call(transactionStatusCallable);
            return this.buildStatusResponse(phonePeHttpResponse);
        }
        catch (RetryException ex) {
            PhonePeHttpResponse phonePeHttpResponse = (PhonePeHttpResponse)ex.getLastFailedAttempt().getResult();
            return this.buildStatusResponse(phonePeHttpResponse);
        }
        catch (Exception ex) {
            log.error("Exception occurred while performing transaction status check");
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", ex.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, "Error executing initiate transaction: " + ex.getMessage(), objectMap, ex);
        }
    }

    private List<String> getParamsList(String transactionId) {
        ArrayList<String> paramsList = new ArrayList<String>();
        paramsList.add(this.merchantConfig.getMerchantId());
        paramsList.add(transactionId);
        return paramsList;
    }

    private String getAPIURL(String transactionId) {
        return String.format(this.apiURLString, this.merchantConfig.getMerchantId(), transactionId);
    }

    private Callable<PhonePeHttpResponse<TransactionStatusResponse>> getCallable(final String apiURL, final List<HttpHeaderPair> headerPairs) {
        return new Callable<PhonePeHttpResponse<TransactionStatusResponse>>(){

            @Override
            public PhonePeHttpResponse<TransactionStatusResponse> call() throws Exception {
                return TransactionStatusChecker.this.transactionClient.getTransactionStatus(headerPairs, apiURL);
            }
        };
    }

    private Predicate<PhonePeHttpResponse<TransactionStatusResponse>> getRetryPredicate() {
        return new Predicate<PhonePeHttpResponse<TransactionStatusResponse>>(){

            public boolean apply(PhonePeHttpResponse<TransactionStatusResponse> transactionStatusResponse) {
                return transactionStatusResponse.getCode().equalsIgnoreCase(PAYMENT_PENDING) || transactionStatusResponse.getCode().equalsIgnoreCase(INTERNAL_SERVER_ERROR);
            }
        };
    }

    private StatusResponse buildStatusResponse(PhonePeHttpResponse<TransactionStatusResponse> transactionStatusResponse) {
        return StatusResponse.builder().transactionId(transactionStatusResponse.getData().getTransactionId()).paymentState(this.getPaymentState(transactionStatusResponse.getCode())).providerReferenceId(transactionStatusResponse.getData().getProviderReferenceId()).amount(transactionStatusResponse.getData().getAmount()).paidAmount(transactionStatusResponse.getData().getPaidAmount()).paymentModes(transactionStatusResponse.getData().getPaymentModes()).build();
    }

    private PaymentState getPaymentState(String statusCode) {
        if (PAYMENT_SUCCESS.equalsIgnoreCase(statusCode)) {
            return PaymentState.PAYMENT_SUCCESS;
        }
        if (PAYMENT_ERROR.equalsIgnoreCase(statusCode) || PAYMENT_DECLINED.equalsIgnoreCase(statusCode) || PAYMENT_CANCELLED.equalsIgnoreCase(statusCode) || TRANSACTION_NOT_FOUND.equalsIgnoreCase(statusCode)) {
            return PaymentState.PAYMENT_FAILED;
        }
        return PaymentState.PAYMENT_PENDING;
    }

    public static TransactionStatusCheckerBuilder builder() {
        return new TransactionStatusCheckerBuilder();
    }

    public ChecksumGenerator getChecksumGenerator() {
        return this.checksumGenerator;
    }

    public static class TransactionStatusCheckerBuilder {
        private TransactionClient transactionClient;
        private MerchantConfig merchantConfig;
        private StatusConfig statusConfig;
        private ChecksumGenerator checksumGenerator;

        TransactionStatusCheckerBuilder() {
        }

        public TransactionStatusCheckerBuilder transactionClient(TransactionClient transactionClient) {
            this.transactionClient = transactionClient;
            return this;
        }

        public TransactionStatusCheckerBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public TransactionStatusCheckerBuilder statusConfig(StatusConfig statusConfig) {
            this.statusConfig = statusConfig;
            return this;
        }

        public TransactionStatusCheckerBuilder checksumGenerator(ChecksumGenerator checksumGenerator) {
            this.checksumGenerator = checksumGenerator;
            return this;
        }

        public TransactionStatusChecker build() {
            return new TransactionStatusChecker(this.transactionClient, this.merchantConfig, this.statusConfig, this.checksumGenerator);
        }

        public String toString() {
            return "TransactionStatusChecker.TransactionStatusCheckerBuilder(transactionClient=" + this.transactionClient + ", merchantConfig=" + this.merchantConfig + ", statusConfig=" + this.statusConfig + ", checksumGenerator=" + this.checksumGenerator + ")";
        }
    }
}

