/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.models.InitParams;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import com.phonepe.sdk.javasdk.utils.KeyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionInitiator {
    private static final Logger log = LoggerFactory.getLogger(TransactionInitiator.class);
    protected TransactionClient transactionClient;
    protected InitConfig initConfig;
    protected MerchantConfig merchantConfig;
    protected ChecksumGenerator checksumGenerator;
    protected PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;
    protected String apiURL;

    public TransactionInitiator(TransactionClient transactionClient, InitConfig initConfig, MerchantConfig merchantConfig, ChecksumGenerator checksumGenerator, PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        this.transactionClient = transactionClient;
        this.initConfig = initConfig;
        this.merchantConfig = merchantConfig;
        this.checksumGenerator = checksumGenerator;
        this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
        this.apiURL = String.format("/%s/debit", this.initConfig.getApiVersion().getValue());
    }

    public InitResponse initiateTransaction(InitParams initParams, int keyIndex) throws PhonePeClientException {
        try {
            PhonePeHttpRequest<?> initRequest = this.buildInitRequest(this.merchantConfig.getMerchantId(), initParams);
            String apiKey = KeyUtils.getAPIKeyFromIndex(this.merchantConfig.getApiKeys(), keyIndex);
            List<String> params = this.getParamsList(initParams.getTransactionId(), initParams.getAmount());
            String checksumHeaderValue = this.checksumGenerator.getChecksumValue(initRequest, this.apiURL, params, apiKey, keyIndex);
            return this.initiateTransaction(initRequest, initParams, checksumHeaderValue);
        }
        catch (PhonePeClientException e) {
            log.error("Error while making call to PhonePe init transaction API");
            throw e;
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe init transaction API", (Throwable)e);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", e.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, "Error executing initiate transaction: " + e.getMessage(), objectMap, e);
        }
    }

    private List<String> getParamsList(String transactionId, Long amount) {
        ArrayList<String> paramsList = new ArrayList<String>();
        paramsList.add(this.merchantConfig.getMerchantId());
        paramsList.add(transactionId);
        paramsList.add(Long.toString(amount));
        return paramsList;
    }

    private InitResponse initiateTransaction(PhonePeHttpRequest<?> phonePeHttpRequest, InitParams initParams, String checksumHeader) throws PhonePeClientException {
        try {
            List<HttpHeaderPair> httpHeaders = HttpUtils.getHttpHeaders(checksumHeader, this.merchantConfig.getProviderId(), initParams.getRedirectURL(), initParams.getRedirectMode(), initParams.getCallbackURL(), initParams.getCallbackMode());
            return this.transactionClient.initTransaction(phonePeHttpRequest, httpHeaders, this.apiURL);
        }
        catch (PhonePeClientException e) {
            log.error("Error while making call to PhonePe init transaction API");
            throw e;
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe init transaction API", (Throwable)e);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", e.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, "Error executing initiate transaction: " + e.getMessage(), objectMap, e);
        }
    }

    protected abstract PhonePeHttpRequest<?> buildInitRequest(String var1, InitParams var2) throws JsonProcessingException;
}

