/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.Consumer;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import java.nio.charset.Charset;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpCommand<T, J> {
    private static final Logger log = LoggerFactory.getLogger(BaseHttpCommand.class);
    OkHttpClient client;
    Endpoint endpoint;
    String url;
    List<HttpHeaderPair> headers = null;
    PhonePeHttpRequest<J> httpRequest;
    ObjectMapper mapper;
    Class<T> responseType;
    TypeReference<T> responseTypeReference;
    Consumer<Exception, T> exceptionConsumer;
    Consumer<ExtractedResponse, T> nonSuccessResponseConsumer;

    BaseHttpCommand(OkHttpClient client, Endpoint endpoint, String url, List<HttpHeaderPair> headers, PhonePeHttpRequest<J> httpRequest, ObjectMapper mapper, Class<T> responseType, Consumer<Exception, T> exceptionConsumer, Consumer<ExtractedResponse, T> nonSuccessResponseConsumer, TypeReference<T> responseTypeReference) {
        this.client = client;
        this.endpoint = endpoint;
        this.url = url;
        this.headers = headers;
        this.httpRequest = httpRequest;
        this.mapper = mapper;
        this.responseType = responseType;
        this.exceptionConsumer = exceptionConsumer;
        this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
        this.responseTypeReference = responseTypeReference;
    }

    RequestBody getRequestBody() throws JsonProcessingException {
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])this.mapper.writeValueAsBytes(this.httpRequest.getData()));
    }

    public abstract Request getRequest(HttpUrl var1) throws JsonProcessingException;

    public void buildHeaders(Request.Builder requestBuilder) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{this.headers})) {
            for (HttpHeaderPair httpHeader : this.headers) {
                requestBuilder.header(httpHeader.getName(), httpHeader.getValue());
            }
        }
    }

    public T execute() throws PhonePeClientException {
        this.preconditions();
        Request request = null;
        try {
            HttpUrl httpUrl = this.endpoint.getUrl(this.url);
            request = this.getRequest(httpUrl);
            log.info("Service request: {}", (Object)request);
            Response response = this.client.newCall(request).execute();
            byte[] responseBody = HttpUtils.body(response);
            if (!response.isSuccessful()) {
                if (this.nonSuccessResponseConsumer != null) {
                    return this.nonSuccessResponseConsumer.consume(this.extract(response, responseBody));
                }
                log.error(String.format("Service call failed statusCode:%d request:%s response:%s", response.code(), request, new String(responseBody)));
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_CLIENT_ERROR, "Service call failure: " + response.code());
            }
            if (ObjectUtils.anyNotNull((Object[])new Object[]{responseBody})) {
                if (this.responseTypeReference != null) {
                    return (T)this.mapper.readValue(responseBody, this.responseTypeReference);
                }
                if (byte[].class.equals(this.responseType)) {
                    return (T)responseBody;
                }
                if (String.class.equals(this.responseType)) {
                    return (T)new String(responseBody, Charset.defaultCharset());
                }
                return (T)this.mapper.readValue(responseBody, this.responseType);
            }
            return null;
        }
        catch (Exception e) {
            if (this.exceptionConsumer != null) {
                return this.exceptionConsumer.consume(e);
            }
            log.error(String.format("Error executing request:%s error:%s", request, e.getMessage()), (Throwable)e);
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, e.getMessage(), e);
        }
    }

    public void preconditions() throws PhonePeClientException {
        Preconditions.checkNotNull((Object)this.client, (Object)"client cant be null");
        Preconditions.checkNotNull((Object)this.endpoint, (Object)"endpoint cant be null");
        Preconditions.checkNotNull((Object)this.url, (Object)"url cant be null");
        Preconditions.checkNotNull((Object)this.mapper, (Object)"object mapper cant be null");
        HttpUtils.checkNotNull(this.responseType, this.responseTypeReference, "both responseType and responseTypeReference cant be null");
    }

    private ExtractedResponse extract(Response response, byte[] responseBody) {
        return ExtractedResponse.builder().body(responseBody).code(response.code()).headers(response.headers()).message(response.message()).protocol(response.protocol()).handshake(response.handshake()).receivedResponseAtMillis(response.receivedResponseAtMillis()).sentRequestAtMillis(response.sentRequestAtMillis()).build();
    }
}

