package com.phonepe.sdk.javasdk.transaction.init.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.AccountConstraintsDecorator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.BaseTransactionInit;
import com.phonepe.sdk.javasdk.transaction.init.decorator.OfferInitDecorator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.models.InitParams;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;


@Slf4j
public class WebTransactionInitiator extends TransactionInitiator {


    @Builder
    public WebTransactionInitiator(final TransactionClient transactionClient,
                                   final InitConfig initConfig,
                                   final MerchantConfig merchantConfig,
                                   final ChecksumGenerator checksumGenerator,
                                   final PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        super(transactionClient, initConfig, merchantConfig,
              checksumGenerator, phonePeHttpRequestCreator);
    }

    @Override
    protected PhonePeHttpRequest<?> buildInitRequest(final String merchantId,
                                                     final InitParams initParams) throws JsonProcessingException {

        TransactionInitComponent transactionInitComponent = BaseTransactionInit.builder()
                                                                               .merchantId(merchantId)
                                                                               .transactionId(initParams.getTransactionId())
                                                                               .amount(initParams.getAmount())
                                                                               .emailId(initParams.getEmailId())
                                                                               .merchantOrderId(StringUtils.isNotEmpty(initParams.getOrderId()) ? initParams.getOrderId()
                                                                                                                                                : initParams.getTransactionId())
                                                                               .merchantUserId(initParams.getUserId())
                                                                               .mobileNumber(initParams.getMobileNumber())
                                                                               .shortName(initParams.getShortName())
                                                                               .subMerchant(initParams.getSubMerchant())
                                                                               .subMerchantId(initParams.getSubMerchantId())
                                                                               .message(initParams.getMessage())
                                                                               .build();
        if (CollectionUtils.isNotEmpty(initParams.getOfferTags())) {
            transactionInitComponent = OfferInitDecorator
                    .builder()
                    .transactionInitComponent(transactionInitComponent)
                    .offerTagIds(initParams.getOfferTags())
                    .build();
        }
        if (CollectionUtils.isNotEmpty(initParams.getAllowedAccountConstraints())) {
            transactionInitComponent = AccountConstraintsDecorator
                    .builder()
                    .transactionInitComponent(transactionInitComponent)
                    .allowedAccountConstraints(initParams.getAllowedAccountConstraints())
                    .build();
        }
        final InitRequest initRequest = transactionInitComponent.getInitRequest();
        return this.phonePeHttpRequestCreator.createPhonePeHttpRequest(initRequest);
    }
}
