package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.enums.APIVersion;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class StatusConfig {

    private APIVersion apiVersion = APIVersion.V3;
    private RetryConfig retryConfig = RetryConfig.builder().build();

    @Builder
    @SuppressWarnings("unused")
    private StatusConfig(final APIVersion apiVersion, final RetryConfig retryConfig) {

        this.apiVersion = apiVersion == null ? APIVersion.V3 : apiVersion;
        this.retryConfig = retryConfig == null ? RetryConfig.builder().build() : retryConfig;
    }
}
