package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.enums.APIVersion;
import com.phonepe.sdk.javasdk.config.models.enums.InitType;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@NoArgsConstructor
public class InitConfig {

    private APIVersion apiVersion = APIVersion.V4;
    private InitType initType = InitType.WEB;

    @Builder
    @SuppressWarnings("unused")
    private InitConfig(final APIVersion apiVersion, final InitType initType) {

        this.apiVersion = apiVersion == null ? APIVersion.V4 : apiVersion;
        this.initType = initType == null ? InitType.WEB : initType;
    }
}
