package com.phonepe.sdk.javasdk.transaction.checksum.payload;

import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;

import java.util.List;


@NoArgsConstructor
public class BodyChecksumGenerator implements ChecksumGenerator {

    @Override
    public String getChecksumValue(final PhonePeHttpRequest<?> request,
                                   final String apiURL,
                                   final List<String> otherParams,
                                   final String apiKey,
                                   final int keyIndex) throws PhonePeClientException{
        StringBuilder checksumPayload = new StringBuilder();
        if(ObjectUtils.anyNotNull(request)){
            if(request.getData() instanceof Base64Request) {
                PhonePeHttpRequest<Base64Request> value = (PhonePeHttpRequest<Base64Request>) request;
                checksumPayload.append(value.getData().getRequest());
            } else {
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, "Base64 Request body not provided to BodyChecksumGenerator");
            }
        }
        checksumPayload.append(apiURL);
        final String checksumValue = ChecksumUtils.generateChecksumValue(checksumPayload.toString(), apiKey);
        return ChecksumUtils.generateChecksumHeader(checksumValue, keyIndex);
    }
}
