/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.checksum.payload;

import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumGenerator;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ParamsChecksumGenerator
implements ChecksumGenerator {
    @Override
    public String getChecksumValue(PhonePeHttpRequest<?> data, String apiURL, List<String> otherParams, String apiKey, int keyIndex) throws PhonePeClientException {
        if (CollectionUtils.isEmpty(otherParams)) {
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Parameter list cannot be empty for params checksum generator");
        }
        StringBuilder checksumPayload = new StringBuilder();
        for (String checksumParam : otherParams) {
            checksumPayload.append(checksumParam);
        }
        String checksumValue = ChecksumUtils.generateChecksumValue(checksumPayload.toString(), apiKey);
        return ChecksumUtils.generateChecksumHeader(checksumValue, keyIndex);
    }
}

