package com.phonepe.sdk.javasdk.transaction.init.decorator;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BaseTransactionInit implements TransactionInitComponent {

    private String merchantId;
    private String transactionId;
    private Long amount;
    private String merchantOrderId;
    private String merchantUserId;
    private String subMerchant;
    private String subMerchantId;
    private String mobileNumber;
    private String message;
    private String emailId;
    private String shortName;

    @Override
    public InitRequest getInitRequest() {
        Preconditions.checkNotNull(this.merchantId);
        Preconditions.checkNotNull(this.transactionId);
        Preconditions.checkNotNull(this.amount);
        if(Strings.isNullOrEmpty(this.message)){
            this.message = getGenericMessage(this.merchantOrderId);
        }
        return InitRequest.builder()
                          .merchantId(this.merchantId)
                          .transactionId(this.transactionId)
                          .merchantOrderId(this.merchantOrderId)
                          .merchantUserId(this.merchantUserId)
                          .email(this.emailId)
                          .subMerchant(this.subMerchant)
                          .subMerchantId(this.subMerchantId)
                          .mobileNumber(this.mobileNumber)
                          .shortName(this.shortName)
                          .amount(this.amount)
                          .message(this.message)
                          .build();
    }

    private String getGenericMessage(final String orderId){
        return String.format("Payment for orderId: %s", orderId);
    }
}
