/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class HttpClientConfig {
    @Min(value=10L)
    @Max(value=1024L)
    private int connections = 10;
    @Max(value=86400L)
    private int idleTimeOutSeconds = 30;
    @Max(value=86400000L)
    private int connectTimeoutMs = 10000;
    @Max(value=86400000L)
    private int opTimeoutMs = 10000;

    public HttpClientConfig(@Min(value=10L) @Max(value=1024L) int connections, @Max(value=86400L) int idleTimeOutSeconds, @Max(value=86400000L) int connectTimeoutMs, @Max(value=86400000L) int opTimeoutMs) {
        this.connections = connections == 0 ? 10 : connections;
        this.idleTimeOutSeconds = idleTimeOutSeconds == 0 ? 30 : idleTimeOutSeconds;
        this.connectTimeoutMs = connectTimeoutMs == 0 ? 10000 : connectTimeoutMs;
        this.opTimeoutMs = opTimeoutMs == 0 ? 10000 : opTimeoutMs;
    }

    public static HttpClientConfigBuilder builder() {
        return new HttpClientConfigBuilder();
    }

    public int getConnections() {
        return this.connections;
    }

    public int getIdleTimeOutSeconds() {
        return this.idleTimeOutSeconds;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public int getOpTimeoutMs() {
        return this.opTimeoutMs;
    }

    public void setConnections(int connections) {
        this.connections = connections;
    }

    public void setIdleTimeOutSeconds(int idleTimeOutSeconds) {
        this.idleTimeOutSeconds = idleTimeOutSeconds;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public void setOpTimeoutMs(int opTimeoutMs) {
        this.opTimeoutMs = opTimeoutMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientConfig)) {
            return false;
        }
        HttpClientConfig other = (HttpClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnections() != other.getConnections()) {
            return false;
        }
        if (this.getIdleTimeOutSeconds() != other.getIdleTimeOutSeconds()) {
            return false;
        }
        if (this.getConnectTimeoutMs() != other.getConnectTimeoutMs()) {
            return false;
        }
        return this.getOpTimeoutMs() == other.getOpTimeoutMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnections();
        result = result * 59 + this.getIdleTimeOutSeconds();
        result = result * 59 + this.getConnectTimeoutMs();
        result = result * 59 + this.getOpTimeoutMs();
        return result;
    }

    public String toString() {
        return "HttpClientConfig(connections=" + this.getConnections() + ", idleTimeOutSeconds=" + this.getIdleTimeOutSeconds() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", opTimeoutMs=" + this.getOpTimeoutMs() + ")";
    }

    public HttpClientConfig() {
    }

    public static class HttpClientConfigBuilder {
        private int connections;
        private int idleTimeOutSeconds;
        private int connectTimeoutMs;
        private int opTimeoutMs;

        HttpClientConfigBuilder() {
        }

        public HttpClientConfigBuilder connections(int connections) {
            this.connections = connections;
            return this;
        }

        public HttpClientConfigBuilder idleTimeOutSeconds(int idleTimeOutSeconds) {
            this.idleTimeOutSeconds = idleTimeOutSeconds;
            return this;
        }

        public HttpClientConfigBuilder connectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        public HttpClientConfigBuilder opTimeoutMs(int opTimeoutMs) {
            this.opTimeoutMs = opTimeoutMs;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this.connections, this.idleTimeOutSeconds, this.connectTimeoutMs, this.opTimeoutMs);
        }

        public String toString() {
            return "HttpClientConfig.HttpClientConfigBuilder(connections=" + this.connections + ", idleTimeOutSeconds=" + this.idleTimeOutSeconds + ", connectTimeoutMs=" + this.connectTimeoutMs + ", opTimeoutMs=" + this.opTimeoutMs + ")";
        }
    }
}

