package com.phonepe.sdk.javasdk.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

@Slf4j
public class Base64Utils {

    private Base64Utils() {
        throw new IllegalStateException("Utility class");
    }

    public static String decodeBase64(final String encodedString) {
        return StringUtils.newStringUtf8(Base64.decodeBase64(encodedString));
    }

    public static String encodeBase64(final String requestString) {
        return StringUtils.newStringUtf8(Base64.encodeBase64(requestString.getBytes()));
    }

    public static <T> Base64Request getBase64Request(final T requestBody) throws JsonProcessingException {
        final String jsonBody = MapperUtils.getMapper().writeValueAsString(requestBody);
        final String b64RequestBody = encodeBase64(jsonBody);
        return Base64Request.builder()
                            .request(b64RequestBody)
                            .build();
    }
}
