package com.phonepe.sdk.javasdk.exception;

import javax.validation.ConstraintViolation;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/**
 * An exception thrown where there is an error parsing a configuration object.
 */
public class PhonePeConfigurationException extends Exception {
    private static final long serialVersionUID = 5325162099634227047L;

    /**
     * Creates a new PhonePeConfigurationException for the given file with given message.
     *
     * @param message   the message to convey
     */
    public PhonePeConfigurationException(String path, String message){
        super(formatMessage(path, Collections.singletonList(message)));
    }

    /**
     * Creates a new PhonePeConfigurationException for the given file with the given errors.
     *
     * @param path      the path of bad configuration file
     * @param errors    the errors in the file
     */
    public <T> PhonePeConfigurationException(String path, Set<ConstraintViolation<T>> errors) {
        super(formatMessage(path, format(errors)));
    }

    public static <T> Collection<String> format(Set<ConstraintViolation<T>> violations) {
        final SortedSet<String> errors = new TreeSet<String>();
        for (ConstraintViolation<?> v : violations) {
            errors.add(format(v));
        }
        return errors;
    }

    public static <T> String format(ConstraintViolation<T> v) {
        return String.format("%s %s", v.getPropertyPath(), v.getMessage());
    }

    private static String formatMessage(String file, Iterable<String> errors) {
        final StringBuilder msg = new StringBuilder(file)
                .append(" has the following errors:\n");
        for (String error : errors) {
            msg.append("  * ").append(error).append('\n');
        }
        return msg.toString();
    }
}