package com.phonepe.sdk.javasdk.config.models;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class ThreadPool {

    private boolean semaphoreIsolation = false;
    private int concurrency = 8;
    private int maxRequestQueueSize = 128;
    private int dynamicRequestQueueSize = 16;
    private int timeout = 5000;

    @Builder
    public ThreadPool(final boolean semaphoreIsolation, final int concurrency,
                      final int maxRequestQueueSize, final int dynamicRequestQueueSize,
                      final int timeout) {
        this.semaphoreIsolation = semaphoreIsolation;
        this.concurrency = concurrency == 0 ? 8 : concurrency;
        this.maxRequestQueueSize = maxRequestQueueSize == 0 ? 128: maxRequestQueueSize;
        this.dynamicRequestQueueSize = dynamicRequestQueueSize == 0 ? 16 :dynamicRequestQueueSize;
        this.timeout = timeout == 0 ? 5000 : timeout;
    }
}
