package com.phonepe.sdk.javasdk.config.models;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

@Data
@NoArgsConstructor
public class HttpClientConfig {

    @Min(10)
    @Max(1024)
    private int connections = 10;

    @Max(86400)
    private int idleTimeOutSeconds = 30;

    @Max(86400000)
    private int connectTimeoutMs = 10000;

    @Max(86400000)
    private int opTimeoutMs = 10000;

    @Builder
    public HttpClientConfig(@Min(10) @Max(1024) int connections,
                            @Max(86400) int idleTimeOutSeconds,
                            @Max(86400000) int connectTimeoutMs,
                            @Max(86400000) int opTimeoutMs) {
        this.connections = connections == 0  ? 10 : connections;
        this.idleTimeOutSeconds = idleTimeOutSeconds == 0 ? 30 : idleTimeOutSeconds;
        this.connectTimeoutMs = connectTimeoutMs == 0 ? 10000 : connectTimeoutMs;
        this.opTimeoutMs = opTimeoutMs == 0 ? 10000 : opTimeoutMs;
    }
}

