package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.enums.Environment;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotNull;
import java.net.URI;

@Data
@NoArgsConstructor
public class Endpoint {

    @NotNull
    private Environment environment;

    private String overrideHost;

    private Boolean overrideSecured;

    @Builder
    public Endpoint(@NotNull final Environment environment,
                    final String overrideHost,
                    final Boolean overrideSecured) {
        this.environment = environment;
        if (StringUtils.isNotEmpty(overrideHost)) {
            this.overrideHost = overrideHost;
            this.environment.setHost(overrideHost);
        }
        if (ObjectUtils.isNotEmpty(overrideSecured)) {
            this.overrideSecured = overrideSecured;
            this.environment.setSecured(overrideSecured);
        }
    }

    public HttpUrl getUrl(final String path) {
        final String protocol = this.environment.isSecured() ? "https" : "http";
        return HttpUrl.get(URI.create(String.format("%s://%s%s", protocol, environment.getHost(), path)));
    }
}
