/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.SDKConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.PhonePeHttpClientFactory;
import com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGeneratorFactory;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiatorFactory;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.init.models.enums.CallbackMode;
import com.phonepe.sdk.javasdk.transaction.init.models.enums.RedirectMode;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreatorFactory;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.utils.KeyUtils;
import java.util.List;
import java.util.Set;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeClient {
    private static final Logger log = LoggerFactory.getLogger(PhonePeClient.class);
    private TransactionInitiator transactionInitiator;
    private CallbackHandler callbackHandler;
    private TransactionStatusChecker statusChecker;
    private int defaultKeyIndex;

    public PhonePeClient(SDKConfig sdkConfig) {
        Preconditions.checkNotNull((Object)sdkConfig);
        this.init(sdkConfig);
    }

    private void init(SDKConfig sdkConfig) {
        HttpClientConfig httpClientConfig = sdkConfig.getHttpClientConfig();
        Endpoint endpoint = sdkConfig.getEndpoint();
        StatusConfig statusConfig = sdkConfig.getStatusConfig();
        MerchantConfig merchantConfig = sdkConfig.getMerchantConfig();
        InitConfig initConfig = sdkConfig.getInitConfig();
        HystrixConfig hystrixConfig = sdkConfig.getHystrixConfig();
        ChecksumGeneratorFactory checksumGeneratorFactory = new ChecksumGeneratorFactory();
        OkHttpClient client = PhonePeHttpClientFactory.buildOkHttpClient(httpClientConfig, endpoint.getEnvironment().isSecured());
        TransactionClient transactionClient = new TransactionClient(endpoint, client, hystrixConfig);
        ChecksumGenerator statusChecksumGenerator = statusConfig.getApiVersion().accept(checksumGeneratorFactory);
        ChecksumGenerator initChecksumGenerator = initConfig.getApiVersion().accept(checksumGeneratorFactory);
        PhonePeHttpRequestCreatorFactory phonePeHttpRequestCreatorFactory = new PhonePeHttpRequestCreatorFactory();
        PhonePeHttpRequestCreator phonePeHttpRequestCreator = (PhonePeHttpRequestCreator)initConfig.getApiVersion().accept(phonePeHttpRequestCreatorFactory);
        TransactionInitiatorFactory transactionInitiatorFactory = TransactionInitiatorFactory.builder().merchantConfig(merchantConfig).initConfig(initConfig).transactionClient(transactionClient).checksumGenerator(initChecksumGenerator).phonePeHttpRequestCreator(phonePeHttpRequestCreator).build();
        this.statusChecker = TransactionStatusChecker.builder().merchantConfig(merchantConfig).statusConfig(statusConfig).transactionClient(transactionClient).checksumGenerator(statusChecksumGenerator).build();
        this.callbackHandler = CallbackHandler.builder().merchantConfig(merchantConfig).transactionStatusChecker(this.statusChecker).build();
        this.transactionInitiator = initConfig.getInitType().accept(transactionInitiatorFactory);
        this.defaultKeyIndex = KeyUtils.getDefaultKeyIndex(merchantConfig.getApiKeys());
    }

    public InitResponse initTransaction(String transactionId, Long amount) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, null, null, "", null, "", null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, String callbackURL, CallbackMode callbackMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, callbackURL, callbackMode);
    }

    public InitResponse initTransaction(String transactionId, Long amount, String redirectUrl, RedirectMode redirectMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, redirectUrl, redirectMode);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, String callbackURL, CallbackMode callbackMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, null, null, "", null, callbackURL, callbackMode);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, String redirectURL, RedirectMode redirectMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, null, null, redirectURL, redirectMode, "", null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, offerTags);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, Set<String> offerTags) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, offerTags, null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags, String callbackURL, CallbackMode callbackMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, offerTags, null, "", null, callbackURL, callbackMode);
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags, String redirectURL, RedirectMode redirectMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, offerTags, redirectURL, redirectMode);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, Set<String> offerTags, String callbackURL, CallbackMode callbackMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, offerTags, null, "", null, callbackURL, callbackMode);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, Set<String> offerTags, String redirectURL, RedirectMode redirectMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, offerTags, null, redirectURL, redirectMode, "", null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, allowedAccountConstraints);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, null, allowedAccountConstraints);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, offerTags, allowedAccountConstraints, "", null, "", null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints, String callbackURL, CallbackMode callbackMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, allowedAccountConstraints, callbackURL, callbackMode);
    }

    public InitResponse initTransaction(String transactionId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectURL, RedirectMode redirectMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, allowedAccountConstraints, redirectURL, redirectMode);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints, String callbackURL, CallbackMode callbackMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, null, allowedAccountConstraints, "", null, callbackURL, callbackMode);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectURL, RedirectMode redirectMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, null, allowedAccountConstraints, redirectURL, redirectMode, "", null);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectURL, RedirectMode redirectMode, String callbackURL, CallbackMode callbackMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, amount, transactionId, userId, "", "", "", "", "", "", offerTags, allowedAccountConstraints, redirectMode, redirectURL, callbackURL, callbackMode);
    }

    public InitResponse initTransaction(String transactionId, Long amount, String orderId, String userId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, String message, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeClientException {
        return this.initTransaction(transactionId, amount, orderId, userId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, message, offerTags, allowedAccountConstraints, null, "", "", null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, String orderId, String userId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, String message, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, RedirectMode redirectMode, String redirectURL, String callbackURL, CallbackMode callMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, amount, orderId, userId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, message, offerTags, allowedAccountConstraints, redirectMode, redirectURL, callbackURL, callMode, this.defaultKeyIndex);
    }

    public InitResponse initTransaction(String transactionId, Long amount, String orderId, String userId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, String message, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, RedirectMode redirectMode, String redirectURL, String callbackURL, CallbackMode callMode, int keyIndex) throws PhonePeClientException {
        return this.transactionInitiator.initiateTransaction(transactionId, amount, orderId, userId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, message, offerTags, allowedAccountConstraints, redirectMode, redirectURL, callMode, callbackURL, keyIndex);
    }

    public StatusResponse handleCallback(String responseReceived, String checksum, long transactionAmount) throws PhonePeClientException {
        return this.callbackHandler.handleCallback(responseReceived, checksum, transactionAmount);
    }

    public StatusResponse checkTransactionStatus(String transactionId) throws PhonePeClientException {
        return this.checkTransactionStatus(transactionId, this.defaultKeyIndex);
    }

    public StatusResponse checkTransactionStatus(String transactionId, int keyIndex) throws PhonePeClientException {
        return this.statusChecker.checkTransactionStatus(transactionId, keyIndex);
    }

    public static PhonePeClientBuilder builder() {
        return new PhonePeClientBuilder();
    }

    public static class PhonePeClientBuilder {
        private SDKConfig sdkConfig;

        PhonePeClientBuilder() {
        }

        public PhonePeClientBuilder sdkConfig(SDKConfig sdkConfig) {
            this.sdkConfig = sdkConfig;
            return this;
        }

        public PhonePeClient build() {
            return new PhonePeClient(this.sdkConfig);
        }

        public String toString() {
            return "PhonePeClient.PhonePeClientBuilder(sdkConfig=" + this.sdkConfig + ")";
        }
    }
}

