/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import javax.validation.constraints.Max;

public class Metrics {
    @Max(value=60000L)
    private int statsTimeInMillis = 60000;
    private int healthCheckInterval = 500;
    private int percentileTimeInMillis = 60000;
    private int percentileBucketSize = 100;
    private int numBucketSize = 100;

    public Metrics(@Max(value=60000L) int statsTimeInMillis, int healthCheckInterval, int percentileTimeInMillis, int percentileBucketSize, int numBucketSize) {
        this.statsTimeInMillis = statsTimeInMillis == 0 ? 60000 : statsTimeInMillis;
        this.healthCheckInterval = healthCheckInterval == 0 ? 500 : healthCheckInterval;
        this.percentileTimeInMillis = percentileTimeInMillis == 0 ? 60000 : percentileTimeInMillis;
        this.percentileBucketSize = percentileBucketSize == 0 ? 100 : percentileBucketSize;
        this.numBucketSize = numBucketSize == 0 ? 100 : numBucketSize;
    }

    public static MetricsBuilder builder() {
        return new MetricsBuilder();
    }

    public int getStatsTimeInMillis() {
        return this.statsTimeInMillis;
    }

    public int getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public int getPercentileTimeInMillis() {
        return this.percentileTimeInMillis;
    }

    public int getPercentileBucketSize() {
        return this.percentileBucketSize;
    }

    public int getNumBucketSize() {
        return this.numBucketSize;
    }

    public void setStatsTimeInMillis(int statsTimeInMillis) {
        this.statsTimeInMillis = statsTimeInMillis;
    }

    public void setHealthCheckInterval(int healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
    }

    public void setPercentileTimeInMillis(int percentileTimeInMillis) {
        this.percentileTimeInMillis = percentileTimeInMillis;
    }

    public void setPercentileBucketSize(int percentileBucketSize) {
        this.percentileBucketSize = percentileBucketSize;
    }

    public void setNumBucketSize(int numBucketSize) {
        this.numBucketSize = numBucketSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatsTimeInMillis() != other.getStatsTimeInMillis()) {
            return false;
        }
        if (this.getHealthCheckInterval() != other.getHealthCheckInterval()) {
            return false;
        }
        if (this.getPercentileTimeInMillis() != other.getPercentileTimeInMillis()) {
            return false;
        }
        if (this.getPercentileBucketSize() != other.getPercentileBucketSize()) {
            return false;
        }
        return this.getNumBucketSize() == other.getNumBucketSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Metrics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatsTimeInMillis();
        result = result * 59 + this.getHealthCheckInterval();
        result = result * 59 + this.getPercentileTimeInMillis();
        result = result * 59 + this.getPercentileBucketSize();
        result = result * 59 + this.getNumBucketSize();
        return result;
    }

    public String toString() {
        return "Metrics(statsTimeInMillis=" + this.getStatsTimeInMillis() + ", healthCheckInterval=" + this.getHealthCheckInterval() + ", percentileTimeInMillis=" + this.getPercentileTimeInMillis() + ", percentileBucketSize=" + this.getPercentileBucketSize() + ", numBucketSize=" + this.getNumBucketSize() + ")";
    }

    public Metrics() {
    }

    public static class MetricsBuilder {
        private int statsTimeInMillis;
        private int healthCheckInterval;
        private int percentileTimeInMillis;
        private int percentileBucketSize;
        private int numBucketSize;

        MetricsBuilder() {
        }

        public MetricsBuilder statsTimeInMillis(int statsTimeInMillis) {
            this.statsTimeInMillis = statsTimeInMillis;
            return this;
        }

        public MetricsBuilder healthCheckInterval(int healthCheckInterval) {
            this.healthCheckInterval = healthCheckInterval;
            return this;
        }

        public MetricsBuilder percentileTimeInMillis(int percentileTimeInMillis) {
            this.percentileTimeInMillis = percentileTimeInMillis;
            return this;
        }

        public MetricsBuilder percentileBucketSize(int percentileBucketSize) {
            this.percentileBucketSize = percentileBucketSize;
            return this;
        }

        public MetricsBuilder numBucketSize(int numBucketSize) {
            this.numBucketSize = numBucketSize;
            return this;
        }

        public Metrics build() {
            return new Metrics(this.statsTimeInMillis, this.healthCheckInterval, this.percentileTimeInMillis, this.percentileBucketSize, this.numBucketSize);
        }

        public String toString() {
            return "Metrics.MetricsBuilder(statsTimeInMillis=" + this.statsTimeInMillis + ", healthCheckInterval=" + this.healthCheckInterval + ", percentileTimeInMillis=" + this.percentileTimeInMillis + ", percentileBucketSize=" + this.percentileBucketSize + ", numBucketSize=" + this.numBucketSize + ")";
        }
    }
}

