/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.Consumer;
import com.phonepe.sdk.javasdk.http.HttpGetCommand;
import com.phonepe.sdk.javasdk.http.HttpPostCommand;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import com.phonepe.sdk.javasdk.utils.MapperUtils;
import java.util.HashMap;
import java.util.List;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionClient {
    private static final Logger log = LoggerFactory.getLogger(TransactionClient.class);
    private final ObjectMapper objectMapper = MapperUtils.getMapper();
    private final OkHttpClient client;
    private final Endpoint endpoint;
    private final HystrixConfig hystrixConfig;

    public TransactionClient(Endpoint endpoint, OkHttpClient okHttpClient, HystrixConfig hystrixConfig) {
        this.endpoint = endpoint;
        this.client = okHttpClient;
        this.hystrixConfig = hystrixConfig;
    }

    public <T> InitResponse initTransaction(PhonePeHttpRequest<T> initRequest, List<HttpHeaderPair> httpHeaders, String url) throws PhonePeClientException {
        try {
            Consumer<ExtractedResponse, T> initResponseConsumer = TransactionClient.handleNonSuccessServiceCall(log, "initTransaction");
            PhonePeHttpResponse phonePeHttpResponse = (PhonePeHttpResponse)HttpPostCommand.builder().url(url).client(this.client).mapper(this.objectMapper).endpoint(this.endpoint).command("transactionInit").responseTypeReference(new TypeReference<PhonePeHttpResponse<InitResponse>>(){}).headers(httpHeaders).httpRequest(initRequest).nonSuccessResponseConsumer(initResponseConsumer).hystrixConfig(this.hystrixConfig).build().executeTracked(TransactionClient.class);
            return (InitResponse)phonePeHttpResponse.getData();
        }
        catch (PhonePeClientException e) {
            log.error("Error while making call to PhonePe init transaction API");
            throw e;
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe init transaction API", (Throwable)e);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", e.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_CLIENT_ERROR, "Error executing http client: for initiating transaction: " + e.getMessage(), objectMap, e);
        }
    }

    public PhonePeHttpResponse<TransactionStatusResponse> getTransactionStatus(List<HttpHeaderPair> httpHeaders, String url) throws PhonePeClientException {
        try {
            Consumer transactionResponseConsumer = TransactionClient.handleNonSuccessServiceCall(log, "transactionStatus");
            return (PhonePeHttpResponse)HttpGetCommand.builder().url(url).client(this.client).mapper(this.objectMapper).endpoint(this.endpoint).command("transactionStatus").responseTypeReference(new TypeReference<PhonePeHttpResponse<TransactionStatusResponse>>(){}).headers(httpHeaders).nonSuccessResponseConsumer(transactionResponseConsumer).hystrixConfig(this.hystrixConfig).build().executeTracked(TransactionClient.class);
        }
        catch (PhonePeClientException e) {
            log.error("Error while making call to PhonePe transaction status API");
            throw e;
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe transaction status API", (Throwable)e);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", e.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_CLIENT_ERROR, "Error executing http client: for transaction status: " + e.getMessage(), objectMap, e);
        }
    }

    public static <T> Consumer<ExtractedResponse, T> handleNonSuccessServiceCall(final Logger log, final String serviceName) {
        return new Consumer<ExtractedResponse, T>(){

            @Override
            public T consume(ExtractedResponse extractedResponse) throws Exception {
                int code = extractedResponse.getCode();
                byte[] body = extractedResponse.getBody();
                String bodyString = new String(body);
                log.error("Error while calling {} service code:{}, response:{}", new Object[]{serviceName, code, bodyString});
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_SERVER_ERROR, serviceName + "http call returned code" + code);
            }
        };
    }
}

