package com.phonepe.sdk.javasdk.transaction.request;

import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import com.phonepe.sdk.javasdk.utils.Base64Utils;
import lombok.Builder;

@Builder
public class Base64RequestCreator<T> implements PhonePeHttpRequestCreator<T> {

    @Override
    public PhonePeHttpRequest<Base64Request> createPhonePeHttpRequest(T data) throws Exception {
        final Base64Request base64Request = Base64Utils.getBase64Request(data);
        return new PhonePeHttpRequest<Base64Request>(base64Request);
    }
}
