package com.phonepe.sdk.javasdk.config.models.enums;

import lombok.Getter;
import lombok.Setter;

public enum Environment {

    UAT("mercury-uat.phonepe.com", true){
        @Override
        public <T> T accept(Environment.EnvironmentVisitor<T> visitor) {
            return visitor.visitUat();
        }
    },
    PRODUCTION("mercury-t2.phonepe.com", true){
        @Override
        public <T> T accept(Environment.EnvironmentVisitor<T> visitor) {
            return visitor.visitProduction();
        }
    };

    @Getter
    @Setter
    private final String host;

    @Getter
    @Setter
    private final boolean secured;

    Environment(final String host, final boolean secured) {
        this.host = host;
        this.secured = secured;
    }

    public abstract <T> T accept(Environment.EnvironmentVisitor<T> visitor);

    public interface EnvironmentVisitor<T> {
        public T visitUat();

        public T visitProduction();
    }
}
