package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.enums.Environment;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import okhttp3.HttpUrl;

import javax.validation.constraints.NotNull;
import java.net.URI;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class Endpoint {

    @NotNull
    private Environment environment;

    public HttpUrl getUrl(final String path) {
        final String protocol = this.environment.isSecured() ? "https" : "http";
        return HttpUrl.get(URI.create(String.format("%s://%s%s", protocol, environment.getHost(), path)));
    }
}
