/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.utils;

import com.phonepe.sdk.javasdk.config.models.APIKeyConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtils {
    private static final Logger log = LoggerFactory.getLogger(KeyUtils.class);

    private KeyUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static int getKeyIndexFromChecksum(String checksumString) {
        return Integer.parseInt(checksumString.substring(checksumString.lastIndexOf(35) + 1));
    }

    public static String getAPIKeyFromIndex(List<APIKeyConfig> apiKeys, int keyIndex) throws PhonePeClientException {
        for (APIKeyConfig apiKey : apiKeys) {
            if (apiKey.getKeyIndex() != keyIndex) continue;
            return apiKey.getKeyValue();
        }
        throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Key not found with given index " + keyIndex + "for the merchant in the config");
    }
}

