package com.phonepe.sdk.javasdk.config.models;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import okhttp3.HttpUrl;

import javax.validation.constraints.NotNull;
import java.net.URI;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@EqualsAndHashCode
@ToString
public class Endpoint {

    @NotNull
    private String host;

    private boolean secured;

    public HttpUrl url(final String path) {
        return HttpUrl.get(URI.create(String.format("http://%s:%d%s", host, 80, path)));
    }

    public HttpUrl secureUrl(final String path) {
        return HttpUrl.get(URI.create(String.format("https://%s:%d%s", host, 443, path)));
    }
}
