package com.phonepe.sdk.javasdk.config.models;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Data
@NoArgsConstructor
public class SDKConfig {

    @Valid
    @NotNull
    private MerchantConfig merchantConfig;

    @Valid
    @NotNull
    private HttpClientConfig httpClientConfig;

    @Valid
    @NotNull
    private InitConfig initConfig;

    @Valid
    @NotNull
    private StatusConfig statusConfig;

    private HystrixConfig hystrixConfig;

    @Builder
    @SuppressWarnings("unused")
    public SDKConfig(final MerchantConfig merchantConfig,final HttpClientConfig httpClientConfig,
                     final InitConfig initConfig,final StatusConfig statusConfig,
                     final HystrixConfig hystrixConfig){

        this.merchantConfig = merchantConfig;
        this.httpClientConfig = httpClientConfig;
        this.initConfig = initConfig;
        this.statusConfig = statusConfig;
        this.hystrixConfig = hystrixConfig == null ? HystrixConfig.builder().build() : hystrixConfig;
    }
}
