/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import java.net.URI;
import okhttp3.HttpUrl;

public class Endpoint {
    private String host;
    private boolean secured;

    public HttpUrl url(String path) {
        return HttpUrl.get((URI)URI.create(String.format("http://%s:%d%s", this.host, 80, path)));
    }

    public HttpUrl secureUrl(String path) {
        return HttpUrl.get((URI)URI.create(String.format("https://%s:%d%s", this.host, 443, path)));
    }

    public static EndpointBuilder builder() {
        return new EndpointBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public Endpoint(String host, boolean secured) {
        this.host = host;
        this.secured = secured;
    }

    public Endpoint() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        return this.isSecured() == other.isSecured();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Endpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + (this.isSecured() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Endpoint(host=" + this.getHost() + ", secured=" + this.isSecured() + ")";
    }

    public static class EndpointBuilder {
        private String host;
        private boolean secured;

        EndpointBuilder() {
        }

        public EndpointBuilder host(String host) {
            this.host = host;
            return this;
        }

        public EndpointBuilder secured(boolean secured) {
            this.secured = secured;
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.host, this.secured);
        }

        public String toString() {
            return "Endpoint.EndpointBuilder(host=" + this.host + ", secured=" + this.secured + ")";
        }
    }
}

