package com.phonepe.sdk.javasdk.config.models;

import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.concurrent.TimeUnit;


@Data
@NoArgsConstructor
public class RetryConfig {

    public static final int MAX_RETRY = 5;
    public static final int MAXIMUM_WAIT_TIME_IN_SECONDS = 10;

    private int maxRetry = MAX_RETRY;

    private int maximumTimeInSeconds = MAXIMUM_WAIT_TIME_IN_SECONDS;

    private WaitStrategy waitStrategy = WaitStrategies.exponentialWait(MAXIMUM_WAIT_TIME_IN_SECONDS,
                                                                      TimeUnit.SECONDS);

    @Builder
    @SuppressWarnings("unused")
    private RetryConfig(Integer maxRetry, Integer maximumTimeInSeconds, WaitStrategy waitStrategy) {
        this.maxRetry = maxRetry == null ? MAX_RETRY : maxRetry;
        this.maximumTimeInSeconds = maximumTimeInSeconds == null ? MAXIMUM_WAIT_TIME_IN_SECONDS : maxRetry;
        this.waitStrategy = waitStrategy == null ? WaitStrategies.exponentialWait(MAXIMUM_WAIT_TIME_IN_SECONDS,
                                                                                  TimeUnit.SECONDS) : waitStrategy;
    }

}
