package com.phonepe.sdk.javasdk.config.models;


import com.phonepe.sdk.javasdk.config.models.enums.APIVersion;
import com.phonepe.sdk.javasdk.config.models.enums.InitType;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@NoArgsConstructor
public class InitConfig {

    @Builder.Default
    private APIVersion apiVersion = APIVersion.V4;

    @Builder.Default
    private InitType initType = InitType.WEB;

    @Builder
    @SuppressWarnings("unused")
    private InitConfig(APIVersion apiVersion, InitType initType) {

        this.apiVersion = apiVersion == null ? APIVersion.V4 : apiVersion;
        this.initType = initType == null ? InitType.WEB : initType;
    }
}
