/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Utils {
    private static final Logger log = LoggerFactory.getLogger(Base64Utils.class);

    public static String decodeBase64(String encodedString) {
        return StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)encodedString));
    }

    public static String encodeBase64(String requestString) {
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])requestString.getBytes()));
    }

    public static <T> Base64Request getBase64Request(T requestBody) throws Exception {
        String jsonBody = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(requestBody);
        String b64RequestBody = Base64Utils.encodeBase64(jsonBody);
        return Base64Request.builder().request(b64RequestBody).build();
    }
}

