package com.phonepe.sdk.javasdk.http;


import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import lombok.*;
import lombok.extern.slf4j.Slf4j;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;

import java.util.List;


@Slf4j
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class HttpGetCommand<T> extends BaseHttpCommand<T> {

    @Builder
    public HttpGetCommand(OkHttpClient client, HystrixConfig hystrixConfig, String command,
                          Endpoint endpoint, String url,
                          @Singular("header") List<HttpHeaderPair> headers, ObjectMapper mapper,
                          Class<T> responseType,
                          Consumer<Exception, T> exceptionConsumer,
                          Consumer<ExtractedResponse, T> nonSuccessResponseConsumer,
                          TypeReference<T> responseTypeReference) {
        super(client, hystrixConfig, command, endpoint, url, headers, null, mapper, responseType,
              exceptionConsumer, nonSuccessResponseConsumer, responseTypeReference);
    }

    public Request getRequest(HttpUrl httpUrl) {
        Request.Builder requestBuilder = new Request.Builder()
                .url(httpUrl)
                .get();
        if (headers != null) {
          for (HttpHeaderPair httpHeader : headers) {
               requestBuilder.header(httpHeader.getName(), httpHeader.getValue());
            }
        }
        return requestBuilder.build();
    }
}

