/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.checksum.payload;

import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumGenerator;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ParamsChecksumGenerator
implements ChecksumGenerator {
    @Override
    public String getChecksumValue(PhonePeHttpRequest<?> data, String apiURL, List<String> otherParams, String apiKey, int keyIndex) throws Exception {
        if (CollectionUtils.isEmpty(otherParams)) {
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Parameter list cannot be empty for params checksum payload");
        }
        StringBuilder checksumPayload = new StringBuilder();
        for (String checksumParam : otherParams) {
            checksumPayload.append(checksumParam);
        }
        String checksumValue = ChecksumUtils.generateChecksumValue(checksumPayload.toString(), apiKey);
        return ChecksumUtils.generateChecksumHeader(checksumValue, keyIndex);
    }

    public static ParamsChecksumGeneratorBuilder builder() {
        return new ParamsChecksumGeneratorBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParamsChecksumGenerator)) {
            return false;
        }
        ParamsChecksumGenerator other = (ParamsChecksumGenerator)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParamsChecksumGenerator;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "ParamsChecksumGenerator()";
    }

    public static class ParamsChecksumGeneratorBuilder {
        ParamsChecksumGeneratorBuilder() {
        }

        public ParamsChecksumGenerator build() {
            return new ParamsChecksumGenerator();
        }

        public String toString() {
            return "ParamsChecksumGenerator.ParamsChecksumGeneratorBuilder()";
        }
    }
}

