/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.checksum.payload;

import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumPayload;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class BodyChecksumPayload
implements ChecksumPayload {
    @Override
    public String getChecksumPayload(PhonePeHttpRequest<?> request, String apiURL, List<String> otherParams) throws Exception {
        StringBuilder checksumPayload = new StringBuilder();
        if (ObjectUtils.isNotEmpty(request)) {
            if (request.getData() instanceof Base64Request) {
                PhonePeHttpRequest<?> value = request;
                checksumPayload.append(((Base64Request)value.getData()).getRequest());
            } else {
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Base64 Request body not provided to BodyChecksumPayload generator");
            }
        }
        checksumPayload.append(apiURL);
        return checksumPayload.toString();
    }

    public static BodyChecksumPayloadBuilder builder() {
        return new BodyChecksumPayloadBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BodyChecksumPayload)) {
            return false;
        }
        BodyChecksumPayload other = (BodyChecksumPayload)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BodyChecksumPayload;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "BodyChecksumPayload()";
    }

    public static class BodyChecksumPayloadBuilder {
        BodyChecksumPayloadBuilder() {
        }

        public BodyChecksumPayload build() {
            return new BodyChecksumPayload();
        }

        public String toString() {
            return "BodyChecksumPayload.BodyChecksumPayloadBuilder()";
        }
    }
}

