package com.phonepe.sdk.javasdk.transaction.checksum.payload;

import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;

import java.util.List;

@Data
@NoArgsConstructor
@Builder
public class BodyChecksumPayload implements ChecksumPayload{

    @Override
    public String getChecksumPayload(PhonePeHttpRequest<?> request,
                                     String apiURL,
                                     List<String> otherParams) throws Exception{
        StringBuilder checksumPayload = new StringBuilder();
        if(ObjectUtils.isNotEmpty(request)){
            if(request.getData() instanceof Base64Request) {
                PhonePeHttpRequest<Base64Request> value = (PhonePeHttpRequest<Base64Request>) request;
                checksumPayload.append(value.getData().getRequest());
            } else {
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Base64 Request body not provided to BodyChecksumPayload generator");
            }
        }
        checksumPayload.append(apiURL);
        return checksumPayload.toString();
    }
}
