/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumPayload;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import com.phonepe.sdk.javasdk.utils.KeyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionInitiator {
    private static final Logger log = LoggerFactory.getLogger(TransactionInitiator.class);
    protected TransactionClient transactionClient;
    protected InitConfig initConfig;
    protected MerchantConfig merchantConfig;
    protected ChecksumPayload checksumPayload;
    protected PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;
    protected String apiURL;

    public TransactionInitiator(TransactionClient transactionClient, InitConfig initConfig, MerchantConfig merchantConfig, ChecksumPayload checksumPayload, PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        this.transactionClient = transactionClient;
        this.initConfig = initConfig;
        this.merchantConfig = merchantConfig;
        this.checksumPayload = checksumPayload;
        this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
        this.apiURL = String.format("/%s/debit", new Object[]{this.initConfig.getApiVersion()});
    }

    public InitResponse initiateTransaction(String transactionId, Long amount, String merchantOrderId, String merchantUserId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, String message, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectMode, String redirectURL, String callbackMode, String callbackURL, int keyIndex) throws PhonePeClientException {
        try {
            PhonePeHttpRequest<?> initRequest = this.buildInitRequest(this.merchantConfig.getMerchantId(), transactionId, amount, merchantOrderId, merchantUserId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, message, offerTags, allowedAccountConstraints);
            String apiKey = KeyUtils.getAPIKeyFromIndex(this.merchantConfig.getApiKeys(), keyIndex);
            List<String> params = this.getParamsList(transactionId, amount);
            String checksumPayload = this.checksumPayload.getChecksumPayload(initRequest, this.apiURL, params);
            String checksumBody = ChecksumUtils.generateChecksumValue(checksumPayload, "", apiKey);
            String checksumHeader = ChecksumUtils.generateChecksumHeader(checksumBody, keyIndex);
            return this.initiateTransaction(initRequest, redirectMode, redirectURL, callbackMode, callbackURL, checksumHeader);
        }
        catch (PhonePeClientException e) {
            log.error("Error while making call to PhonePe init transaction API");
            throw e;
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe init transaction API", (Throwable)e);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", e.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, "Error executing initiate transaction: " + e.getMessage(), objectMap, e);
        }
    }

    private List<String> getParamsList(String transactionId, Long amount) {
        ArrayList<String> paramsList = new ArrayList<String>();
        paramsList.add(this.merchantConfig.getMerchantId());
        paramsList.add(transactionId);
        paramsList.add(Long.toString(amount));
        return paramsList;
    }

    private InitResponse initiateTransaction(PhonePeHttpRequest<?> phonePeHttpRequest, String redirectMode, String redirectURL, String callMode, String callbackURL, String checksumHeader) throws PhonePeClientException {
        try {
            List<HttpHeaderPair> httpHeaders = HttpUtils.getHttpHeaders(checksumHeader, this.merchantConfig.getProviderId(), redirectURL, redirectMode, callbackURL, callMode);
            return this.transactionClient.initTransaction(phonePeHttpRequest, httpHeaders, this.apiURL);
        }
        catch (PhonePeClientException e) {
            log.error("Error while making call to PhonePe init transaction API");
            throw e;
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe init transaction API", (Throwable)e);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", e.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.EXECUTION_ERROR, "Error executing initiate transaction: " + e.getMessage(), objectMap, e);
        }
    }

    protected abstract PhonePeHttpRequest<?> buildInitRequest(String var1, String var2, Long var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, Set<String> var12, List<AllowedAccountConstraint> var13) throws Exception;

    public TransactionClient getTransactionClient() {
        return this.transactionClient;
    }

    public InitConfig getInitConfig() {
        return this.initConfig;
    }

    public MerchantConfig getMerchantConfig() {
        return this.merchantConfig;
    }

    public ChecksumPayload getChecksumPayload() {
        return this.checksumPayload;
    }

    public PhonePeHttpRequestCreator<InitRequest> getPhonePeHttpRequestCreator() {
        return this.phonePeHttpRequestCreator;
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public void setTransactionClient(TransactionClient transactionClient) {
        this.transactionClient = transactionClient;
    }

    public void setInitConfig(InitConfig initConfig) {
        this.initConfig = initConfig;
    }

    public void setMerchantConfig(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
    }

    public void setChecksumPayload(ChecksumPayload checksumPayload) {
        this.checksumPayload = checksumPayload;
    }

    public void setPhonePeHttpRequestCreator(PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
    }

    public void setApiURL(String apiURL) {
        this.apiURL = apiURL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionInitiator)) {
            return false;
        }
        TransactionInitiator other = (TransactionInitiator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionClient this$transactionClient = this.getTransactionClient();
        TransactionClient other$transactionClient = other.getTransactionClient();
        if (this$transactionClient == null ? other$transactionClient != null : !this$transactionClient.equals(other$transactionClient)) {
            return false;
        }
        InitConfig this$initConfig = this.getInitConfig();
        InitConfig other$initConfig = other.getInitConfig();
        if (this$initConfig == null ? other$initConfig != null : !((Object)this$initConfig).equals(other$initConfig)) {
            return false;
        }
        MerchantConfig this$merchantConfig = this.getMerchantConfig();
        MerchantConfig other$merchantConfig = other.getMerchantConfig();
        if (this$merchantConfig == null ? other$merchantConfig != null : !((Object)this$merchantConfig).equals(other$merchantConfig)) {
            return false;
        }
        ChecksumPayload this$checksumPayload = this.getChecksumPayload();
        ChecksumPayload other$checksumPayload = other.getChecksumPayload();
        if (this$checksumPayload == null ? other$checksumPayload != null : !this$checksumPayload.equals(other$checksumPayload)) {
            return false;
        }
        PhonePeHttpRequestCreator<InitRequest> this$phonePeHttpRequestCreator = this.getPhonePeHttpRequestCreator();
        PhonePeHttpRequestCreator<InitRequest> other$phonePeHttpRequestCreator = other.getPhonePeHttpRequestCreator();
        if (this$phonePeHttpRequestCreator == null ? other$phonePeHttpRequestCreator != null : !this$phonePeHttpRequestCreator.equals(other$phonePeHttpRequestCreator)) {
            return false;
        }
        String this$apiURL = this.getApiURL();
        String other$apiURL = other.getApiURL();
        return !(this$apiURL == null ? other$apiURL != null : !this$apiURL.equals(other$apiURL));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionInitiator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionClient $transactionClient = this.getTransactionClient();
        result = result * 59 + ($transactionClient == null ? 43 : $transactionClient.hashCode());
        InitConfig $initConfig = this.getInitConfig();
        result = result * 59 + ($initConfig == null ? 43 : ((Object)$initConfig).hashCode());
        MerchantConfig $merchantConfig = this.getMerchantConfig();
        result = result * 59 + ($merchantConfig == null ? 43 : ((Object)$merchantConfig).hashCode());
        ChecksumPayload $checksumPayload = this.getChecksumPayload();
        result = result * 59 + ($checksumPayload == null ? 43 : $checksumPayload.hashCode());
        PhonePeHttpRequestCreator<InitRequest> $phonePeHttpRequestCreator = this.getPhonePeHttpRequestCreator();
        result = result * 59 + ($phonePeHttpRequestCreator == null ? 43 : $phonePeHttpRequestCreator.hashCode());
        String $apiURL = this.getApiURL();
        result = result * 59 + ($apiURL == null ? 43 : $apiURL.hashCode());
        return result;
    }

    public String toString() {
        return "TransactionInitiator(transactionClient=" + this.getTransactionClient() + ", initConfig=" + this.getInitConfig() + ", merchantConfig=" + this.getMerchantConfig() + ", checksumPayload=" + this.getChecksumPayload() + ", phonePeHttpRequestCreator=" + this.getPhonePeHttpRequestCreator() + ", apiURL=" + this.getApiURL() + ")";
    }
}

