package com.phonepe.sdk.javasdk.transaction.checksum.payload;

import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;


@Data
@NoArgsConstructor
@Builder
public class ParamsChecksumPayload implements ChecksumPayload {

    @Override
    public String getChecksumPayload(PhonePeHttpRequest<?> data,
                                     String apiURL,
                                     List<String> otherParams) throws Exception{

        if(CollectionUtils.isEmpty(otherParams))
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Parameter list cannot be empty for params checksum generator");
        StringBuilder checksumPayload = new StringBuilder();
        for (String checksumParam : otherParams)
            checksumPayload.append(checksumParam);
        return checksumPayload.toString();
    }
}
