package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantContext;
import com.phonepe.sdk.javasdk.transaction.init.models.OfferContext;
import com.phonepe.sdk.javasdk.transaction.init.models.OfferTag;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;

import java.util.HashSet;
import java.util.Set;

@Slf4j
public class OfferInitDecorator extends InitRequestDecorator {

    private Set<String> offerTagIds;

    @Builder
    public OfferInitDecorator(final TransactionInitComponent transactionInitComponent,
                              final Set<String> offerTagIds) {
        super(transactionInitComponent);
        this.offerTagIds = offerTagIds;
    }

    //TODO: Check if it is a good practise to modify an object like this and return.
    @Override
    public InitRequest getInitRequest(final String merchantId,
                                      final String transactionId,
                                      final Long amount) {
        InitRequest initRequest = this.transactionInitComponent.getInitRequest(merchantId, transactionId, amount);
        Set<OfferTag> offerTagSet = getOfferTags(amount);
        OfferContext offerContext = OfferContext.builder()
                                                .tags(offerTagSet)
                                                .build();
        MerchantContext merchantContext = initRequest.getMerchantContext();
        if (merchantContext != null) {
            merchantContext.setOfferContext(offerContext);
        } else {
            merchantContext = MerchantContext.builder()
                                             .offerContext(offerContext)
                                             .build();

        }
        initRequest.setMerchantContext(merchantContext);
        return initRequest;
    }

    private Set<OfferTag> getOfferTags(final Long amount){
        Set<OfferTag> offerTags = new HashSet<OfferTag>();
        for (String tagId : this.offerTagIds){
            offerTags.add(OfferTag.builder()
                                  .id(tagId)
                                  .amount(amount)
                                  .build());
        }
        return offerTags;
    }

}
